#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# -*- perl -*-
# "@(#)29   1.143   src/csm/core/pm/NodeUtils.pm.perl, csmcore, csm_rameh, rameh0431a 6/29/04 11:13:24"
#
#--------------------------------------------------------------------------------

package NodeUtils;

use strict;

#     locale tells perl to honor locale for sorting, dates, etc.
#            More info about locale.pm and perl handling of locales can be found in
#            /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.
use locale;
use Socket;
use File::Basename;

use MessageUtils;
use NetworkUtils;
require CSMDefs;

my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;
my $NODEGROUPEXPMEM_WARNING = 1;

# $NodeUtils::NO_MESSAGES;    # Set this to 1 if you do not want NodeUtils to
# print any error msgs

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
# this out before calling a NodeUtils function,
# if you want to check it afterwards.

BEGIN
{

    $::progname=basename $0;

    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

    $MSGCAT = 'nodecmds.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'NodeUtils';

    #set LD_ASSUME_KERNEL if running on a RH EL 3 machine
    #    my $rh_relfile = "/etc/redhat-release";
    #    my $rh_vers    = '^Red Hat Enterprise Linux .* release 3 (.*)$';
    #    if (-f $rh_relfile)
    #    {
    #        `/bin/grep \"$rh_vers\" $rh_relfile > /dev/null 2>&1`;
    #        my $exit = $? >> 8;
    #        if ($exit == 0)
    #        {
    #            $ENV{'LD_ASSUME_KERNEL'} = "2.4.19";
    #        }
    #    }
}

# Generally, we don't allow CSM commands to be run on a backup management server.
# However we do allow certain commands, and if the CSM_HAMS_CONTROL environment
# variable is set, we allow 'em all.
if (   ($::progname ne "nodestatus")   # We have to allow nodestatus and write_status because they are
    && ($::progname ne "write_status") # used by DMSRM, and the call to lsrsrc-api below would deadlock.
                                       #
    && ($::progname ne "csmconfig")    # You need to be able to install a license (because you can't run
                                       # addlcsext without a license).
    && ($::progname ne "addlcsext")    # You should be able to add or remove the 
    && ($::progname ne "rmlcsext")     # Linux Cluster Support extension. 
    && (!$ENV{'CSM_HAMS_CONTROL'}))    # You can run any CSM command if env var is set.
{
    my $hamode =
      `CT_MANAGEMENT_SCOPE=1 lsrsrc-api -i -s IBM.DmsCtrl::::HAMode 2>/dev/null`;
    if (($hamode != 0) && ($hamode != 1))
    {
        MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E1',
                                     'EMsgCannotRunCSMCommands');
    }
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use NodeUtils;" line

#--------------------------------------------------------------------------------

=head1    NodeUtils

=head2    Package Description

This program module file, supports the CSM/install Node dependencies, and
provides general utilities used by the node commands and a few other parts of
CSM.

If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use of
         your contrib.

    2. Your contrib is under the correct heading and is in alphabetical order
    under that heading.

    3. You test your contribution by running from the command line:  

       pod2html  --verbose --title=NodeUtils NodeUtils.pm.perl --outfile=NodeUtils.html
       
       and examining the ./NodeUtils.html file in a browser.

=cut

#--------------------------------------------------------------------------------

=head2    Package Dependancies

    package NodeUtils;


    use strict;

    locale tells perl to honor locale for sorting, dates, etc.
    More info about locale.pm and perl handling of locales can be found in
    /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.

    use locale;
    use Socket;
    use MessageUtils;
    use NetworkUtils;


=cut

#--------------------------------------------------------------------------------

=head2    Global "umask" Setting


    umask(0022);

    umask  sets umask for all CSM files so that group and world
    only have read permissions.  To change it, simply use the
    umask call in your script, after the "use NodeUtils;" line

=cut

#--------------------------------------------------------------------------------

=head1  Subroutines by Functional Group

=cut

#--------------------------------------------------------------------------------

=head2    Misc Tools

=cut

#--------------------------------------------------------------------------------

=head3    csm_license_valid

    Check the status of a CSM License.

    Arguments:
        none
    Returns:
          1 -    a CSM license exists & is not expired
          0 -    no license exists or it has expired
         -1 -    encountered a problem determining status
    Globals:
        none
    Error:
        see returns
    Example:
        not used
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub csm_license_valid
{
    my $outref =
      NodeUtils->runrmccmd('runact-api', "-c IBM.DmsCtrl::::isLicenseValid");

    if (!$outref || @$outref[0] =~ /::0$/)
    {
        return 0;
    }
    else
    {
        return 1;
    }
}

#--------------------------------------------------------------------------------

=head3    distribution

     Returns the distribution and version of the current machine in the
    form:
        <distro> <version>

    Arguments:
        none
    Returns:
        distro and version strings separated by a space.
    Globals:
        none
    Error:
        Returns undef if it is an unknown distro.
    Example:
         NodeUtils->distribution();
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub distribution
{
    if (!defined($distro))
    {

        # see info.c of the guname tool in gnome-utils for examples
        # of supporting other distros
        if (-f '/etc/redhat-release')
        {
            my $s = NodeUtils->readFile('/etc/redhat-release');

            #print "s=$s";
            my ($name, $version) = split(/ release /, $s);
            $version = (split(' ', $version))[0];    # Strip codename
            if (($name =~ /Advanced/) && ($version =~ /AS/))
            {
                $version =~ s/AS$//;                 # Strip AS off the end
                $name = 'RedHatAS';
            }
            elsif (   (($name =~ /Enterprise/) && ($version =~ /AS/))
                   || (($name =~ /Enterprise/) && ($name =~ /AS/)))
            {
                $version =~ s/AS$//;
                $name = 'RedHatEL-AS';
            }
            elsif (($version =~ /WS/) || ($name =~ /WS/))
            {
                $version =~ s/WS$//;
                $name = 'RedHatEL-WS';

            }
            elsif (($version =~ /ES/) || ($name =~ /ES/))
            {
                $version =~ s/ES$//;
                $name = 'RedHatEL-ES';

            }
            else
            {
                $name = 'RedHat';
            }

            #print "name=$name version=$version\n";
            $distro = $name . ' ' . $version;
        }
        elsif (-f '/etc/SuSE-release')
        {
            my $s = NodeUtils->readFile('/etc/SuSE-release');

            #print "s=$s";
            my $d = 'SuSE';
            if (($s =~ /SLES/s)||($s =~ /SUSE LINUX/s))
            {
                $d = 'SLES';
            }
            my ($version) = $s =~ /VERSION\s*=\s*(\d+\.\d+)/;
	    if(!length($version))
            {
		   ($version) = $s =~ /VERSION\s+=\s+(\d+)/;
		    #my ($version) = (split("= ", $s))[1];
            }

            $distro = "$d $version";
        }
        else
        {
            $distro = '';
        }    # this prevents it from trying to find it every time
    }

    return (length($distro) ? $distro : undef);
}

#--------------------------------------------------------------------------------

=head3    equalArrays

    Compares 2 arrays and returns true if they are the same length and all
    of their elements are equal.  Both arrays are references.

    Arguments:
        ref_array1
        ref_array2
    Returns:
        bool_ret - 1 or 0
    Globals:
        none
    Error:
        none
    Example:
        unused
    Comments:
        unused

=cut

#--------------------------------------------------------------------------------

sub equalArrays
{
    my ($class, $a1, $a2) = @_;
    my $len1 = scalar(@$a1);
    if ($len1 != scalar(@$a2)) { return 0; }
    for (my $i = 0 ; $i < $len1 ; $i++)
    {
        if ($$a1[$i] ne $$a2[$i]) { return 0; }
    }
    return 1;
}

#--------------------------------------------------------------------------------

=head3    isAIX

    returns 1 if localHost is AIX

    Arguments:
        none
    Returns:
        1 - localHost is AIX
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isAIX()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isAIX
{
    if ($^O =~ /^aix/i) { return 1; }
    else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isLinux

    returns 1 if localHost is Linux

    Arguments:
        none
    Returns:
        1 - localHost is Linux
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isLinux()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isLinux
{
    if ($^O =~ /^linux/i) { return 1; }
    else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    ispLinux

    returns 1 if localHost is pLinux

    Arguments:
        none
    Returns:
        1 - localHost is pLinux
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->ispLinux()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isPLinux
{
    my $arch = `/bin/uname -m`;
    chomp($arch);
    if ($arch eq "ppc64") { return 1; }
    else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isMgmtSvr

    returns 1 if localHost is a CSM Management Server

    Arguments:
        none
    Returns:
        1 - localHost is a Managment Sever
        0 - localHost is not
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isMgmtSvr()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isMgmtSvr
{

    # Note: we could check for the csm.server, but that check is slower and OS dependent.
    if (-f '/usr/bin/lsrsrc-api' && -f '/usr/sbin/rsct/bin/IBM.DMSRMd')
    {
        return 1;
    }
    else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isNode

    returns 1 if localHost is CSM node or Management Server.

    Arguments:
        none
    Returns:
        1 - localHost is a CSM Node or Management Sever
        0 - localHost is neither
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isNode()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isNode
{

    # Note: we could check for the csm.client, but that check is slower and OS dependent.
    if (-f '/usr/bin/lsrsrc-api' && -f '/usr/sbin/rsct/bin/IBM.CSMAgentRMd')
    {
        return 1;
    }
    else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isRoot

    returns 1 if the effective user running this subroutine is the root user.

    Arguments:
        none
    Returns:
        1 - effective user is root
        0 - effective user is not root.
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isRoot()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isRoot { return $> == 0; }

#--------------------------------------------------------------------------------

=head3    programName

     Return the name of the perl script currently being executed, w/o the path.

    Arguments:
        none
    Returns:
        program name without the path
    Globals:
        none
    Error:
        none
    Example:
         return NodeUtils->programName() . ":  Houstin , we have a problem.\n";
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub programName
{
    my $progname = $0;
    $progname =~ s|.*/([^/]+?)$|$1|;    # on linux we have to strip the path
    return $progname;
}

#--------------------------------------------------------------------------------

=head3    quote

    Quote a string, taking into account embedded quotes.  This function is most
    useful when passing string through the shell to another cmd.  It handles one
    level of embedded double quotes, single quotes, and dollar signs.

    Arguments:
        string to quote
    Returns:
        quoted string
    Globals:
        none
    Error:
        none
    Example:
         if (defined($$opthashref{'WhereStr'})) {
            $where = NodeUtils->quote($$opthashref{'WhereStr'});
        }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub quote
{
    my ($class, $str) = @_;

    # if the value has imbedded double quotes, use single quotes.  If it also has
    # single quotes, escape the double quotes.
    if (!($str =~ /\"/))    # no embedded double quotes
    {
        $str =~ s/\$/\\\$/sg;    # escape the dollar signs
	$str =~ s/\`/\\\`/sg;
        $str = qq("$str");
    }
    elsif (!($str =~ /\'/)) { $str = qq('$str'); }   # no embedded single quotes
    else    # has both embedded double and single quotes
    {

        # Escape the double quotes.  (Escaping single quotes does not seem to work
        # in the shells.)
        $str =~ s/\"/\\\"/sg;    #" this comment helps formating
        $str =~ s/\$/\\\$/sg;    # escape the dollar signs
	$str =~ s/\`/\\\`/sg;
        $str = qq("$str");
    }
}

#--------------------------------------------------------------------------------

=head3    readFile

    Read a file and return its content.

    Arguments:
        filename
    Returns:
        file contents or undef
    Globals:
        none
    Error:
        undef
    Example:
        my $blah = NodeUtils->readFile('/etc/redhat-release');
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub readFile
{
    my ($class, $filename) = @_;
    open(FILE, "<$filename") or return undef;
    my @contents;
    @contents = <FILE>;
    close(FILE);
    if (wantarray) { return @contents; }
    else { return join('', @contents); }
}

#--------------------------------------------------------------------------------

=head2    Attribute Layer

=cut


#--------------------------------------------------------------------------------

=head3    checkForNotFound

        Checks to see if listnodeattrs couldn't find some nodes.

        Arguments:
                $nodeList

        Returns:
                none.
        Globals:
            $::LISTNODEATTRS_NUMNOTFOUND
        Error:
                E12
        Example:
                NodeUtils->checkForNotFound($refnodes);
        Comments:
                none

=cut

#-------------------------------------------------------------------------#

sub checkForNotFound
{
    my ($class, $nodelist) = @_;
    if ($::LISTNODEATTRS_NUMNOTFOUND)
    {
        if (scalar(@$nodelist) == 1)
        {
            NodeUtils->messageFromCat(
                                      'nodecmds.cat',       $::MSGMAPPATH,
                                      'lsnode',             'E12',
                                      'EMsgNODE_NOT_FOUND', $$nodelist[0]
                                      );
        }
        elsif (scalar(@$nodelist) <= 10)
        {
            NodeUtils->messageFromCat(
                                      'nodecmds.cat',
                                      $::MSGMAPPATH,
                                      'lsnode',
                                      'W12',
                                      'EMsgSOME_NOT_FOUND_LIST',
                                      join(', ', @$nodelist)
                                      );
        }
        else
        {
            NodeUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH, 'lsnode',
                                      'W12', 'EMsgSOME_NOT_FOUND');
        }
    }
}

#--------------------------------------------------------------------------------

=head3    check_valid_install_distros

        Check whether current node's InstallDistributionName and
        InstallDistributionVersion is valid for full installation 

        Arguments:
                $installMethod
                $distro
        Returns:
                -1 - couldn't find valid install distro
                 0 - found valid install distro
        Globals:
                none
        Error:
                -1 - on failure
        Example:
                 my $rc =
                   NodeUtils->check_valid_install_distros("autoyast",$distro);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub check_valid_install_distros
{
    my ($class, $installmethod, $distro) = @_;
    my @VALID_AUTOYAST_DISTROS = ('SuSE8.1', 'SLES8.1', 'SLES9');

    if (!grep(/^$distro$/, @VALID_AUTOYAST_DISTROS))
    {
        return -1;
    }
    return 0;
}


#--------------------------------------------------------------------------------

=head3	common_install_method

        Test that the install method attribute is identical
	across all the nodes in the global %::NODEHASH.

        Arguments:
                uses global below
        Returns:
                a scalar value of the InstallMethod node attribute held in
		common by all nodes in the %::NODEHASH ( "kickstart" || "yast" ).
        Globals:
                %::NODEHASH - input list of nodes to check
        Error:
                Exits with an error if the InstallMethod attribute is not
                the same on all the nodes. 
        Example:
                $::INSTALL_METHOD  = NodeUtils->common_install_method();
        Comments:

		May be used in conjuction with "NodeUtils->get_common_attrs()"
		but this routine exists to handle an idiosyncracy in installnode().

=cut

#--------------------------------------------------------------------------------

sub common_install_method
{

    my $const_attr	= 0;			# the InstallMethod value
    my @hosts		= keys %::NODEHASH;	# all hosts
    my $test_host	= @hosts[0];		# just get the first one

    if ( $test_host ) # not empty
    {
        # constant value to test against
        $const_attr = $::NODEHASH{$test_host}{'InstallMethod'};

    }
    else
    {
        NodeUtils->messageFromCat(
				'csmInstall.cat',
				$::MSGMAPPATH,
				'csminstall',
                               	'E',
				'EMsgNO_ATTR',
				'InstallMethod');
     }

    # go through all hosts and compare InstallMethod to $const_attr

    foreach $test_host (@hosts)
    {
        my $next_hash_value = $::NODEHASH{$test_host}{'InstallMethod'};
    
        if ( $next_hash_value ne $const_attr )
        {
            NodeUtils->messageFromCat(
		    			'csmInstall.cat',
		    			$::MSGMAPPATH,
		    			'csminstall',
       	                            	'E1',
					'EMsgDIFFERENT_ATTR',
		    			'InstallMethod');
        }
    }

    return $const_attr;
}


#-------------------------------------------------------------------------#

=head3    getBladeStatus

        Returns a reference to a hash of nodeName/[yes|no].  Determines whether each
    node in the array is or is not a blade.

        Arguments:
                @node_list  -  an array of nodesNames.
        Returns:
                A hash ref of { node => yes or no }
        Error:
                none
        Example:
                $ref_bladeStatus = NodeUtils->getBladeStatus(@goodNodes);
        Comments:
                getBladeStatus will not verify that the nodes are defined in
        the Database.

=cut

#--------------------------------------------------------------------------------

sub getBladeStatus
{

    # local variables.
    my ($node, $nodes, %nodes, $rc, $rv, $cmd, @stdout, $line);

    # first strip the class name:
    shift;

    # need to do 50 at a time so that we don't have scaling problems.
    $nodes = join(',', @_);

    # the command to find out whether we have a blade or not is this:
    $cmd = "/opt/csm/bin/lshwstat -n $nodes blade";

    # do runcmd, but do not exit if there is an error.  Just
    # set the return code.
    @stdout = NodeUtils->runcmd("$cmd");
    foreach $line (@stdout)
    {
        ($node, $rv) = split(': ', $line);
        $nodes{$node} = $rv;
    }
    return \%nodes;
}

#--------------------------------------------------------------------------------

=head3    get_common_attrs

        Get the common attributes across all the nodes for the follwoing attrs:

                InstallDistributionName 
                InstallDistributionVersion 
                InstallPkgArchitecture 
                InstallCSMVersion 

        Arguments:
                uses global below
        Returns:
		Array of common attribute values on success

        Globals:
                %::NODEHASH - input list of nodes to check
        Error:
                Exits with an error if one of the attributes is not
                the same on all the nodes in %::NODEHASH 
        Example:
                ($::DISTRO_NAME,
                $::DISTRO_VERSION,
                $::ARCH,
                $::CSM_VERSION ) = NodeUtils->get_common_attrs();
        Comments:


=cut

#--------------------------------------------------------------------------------

sub get_common_attrs
{

    # no parameters...

    my ($hostname, $distro_name, $distro_version, $arch, $csm_version);

    my ($InstallDistributionName);
    my ($InstallDistributionVersion);
    my ($InstallPkgArchitecture);
    my ($InstallCSMVersion);

    my ($errors)			   = 0;
    my $InstallCSMVersion_Err_Flg          = 0;
    my $InstallPkgArchitecture_Err_Flg     = 0;
    my $InstallDistributionVersion_Err_Flg = 0;
    my $InstallDistributionName_Err_Flg    = 0;
    my $DistributionName_Err_Flg           = 0;
    my $DistributionVersion_Err_Flg        = 0;
    my $PkgArchitecture_Err_Flg            = 0;
    my $CSMVersion_Err_Flg                 = 0;

    foreach $hostname (keys %::NODEHASH)
    {
        $InstallDistributionName	= $::NODEHASH{$hostname}{'InstallDistributionName'};
        $InstallDistributionVersion	= $::NODEHASH{$hostname}{'InstallDistributionVersion'};
        $InstallPkgArchitecture		= $::NODEHASH{$hostname}{'InstallPkgArchitecture'};
        $InstallCSMVersion		= $::NODEHASH{$hostname}{'InstallCSMVersion'};

        if (!$distro_name) { $distro_name = $InstallDistributionName; }
        if (!$distro_version) { $distro_version = $InstallDistributionVersion; }
        if (!$csm_version) { $csm_version = $InstallCSMVersion; }
        if (!$arch) { $arch = $InstallPkgArchitecture; }


        if ("$distro_name" and ($InstallDistributionName ne $distro_name))
        {
            $errors++;
            $InstallDistributionName_Err_Flg++;
        }

        if ("$distro_version"
            and ($InstallDistributionVersion ne $distro_version))
        {
            $errors++;
            $InstallDistributionVersion_Err_Flg++;
        }

        if ("$arch"
            and ($InstallPkgArchitecture ne $arch))
        {
            $errors++;
            $InstallPkgArchitecture_Err_Flg++;
        }

        if ("$csm_version"
            and ($InstallCSMVersion ne $csm_version))
        {
            $errors++;
            $InstallCSMVersion_Err_Flg++;
        }
    }

    if (!$distro_name)
    {
        $errors++;
        $DistributionName_Err_Flg++;
    }
    if (!$distro_version)
    {
        $errors++;
        $DistributionVersion_Err_Flg++;
    }
    if (!$arch)
    {
        $errors++;
        $PkgArchitecture_Err_Flg++;
    }
    if (!$csm_version)
    {
        $errors++;
        $CSMVersion_Err_Flg++;
    }

    if ($InstallDistributionName_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',
                                  $::MSGMAPPATH,
                                  'csminstall',
                                  'E',
                                  'EMsgDIFFERENT_ATTR',
                                  'InstallDistributionName'
                                  );
    }
    if ($InstallDistributionVersion_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',
                                  $::MSGMAPPATH,
                                  'csminstall',
                                  'E',
                                  'EMsgDIFFERENT_ATTR',
                                  'InstallDistributionVersion'
                                  );
    }
    if ($InstallPkgArchitecture_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',
                                  $::MSGMAPPATH,
                                  'csminstall',
                                  'E',
                                  'EMsgDIFFERENT_ATTR',
                                  'InstallPkgArchitecture'
                                  );
    }
    if ($InstallCSMVersion_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',     $::MSGMAPPATH,
                                  'csminstall',         'E',
                                  'EMsgDIFFERENT_ATTR', 'InstallCSMVersion'
                                  );
    }
    if ($DistributionName_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat', $::MSGMAPPATH,
                                  'csminstall',     'E',
                                  'EMsgNO_ATTR',    'InstallDistributionName'
                                  );
    }
    if ($DistributionVersion_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat',
                                  $::MSGMAPPATH,
                                  'csminstall',
                                  'E',
                                  'EMsgNO_ATTR',
                                  'InstallDistributionVersion'
                                  );
    }
    if ($PkgArchitecture_Err_Flg > 0)
    {
        NodeUtils->messageFromCat(
                                  'csmInstall.cat', $::MSGMAPPATH,
                                  'csminstall',     'E',
                                  'EMsgNO_ATTR',    'InstallPkgArchitecture'
                                  );
    }
    if ($CSMVersion_Err_Flg > 0)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E', 'EMsgNO_ATTR', 'InstallCSMVersion');
    }

    exit $errors if ($errors);

    my @return_array = ($distro_name, $distro_version, $arch, $csm_version);

    return (@return_array);
}

#--------------------------------------------------------------------------------

=head3    get_CSMVersion

        Get the version of csm component that is installed on the 
        management server.

        Arguments:
                $component
                $showfixlevel
        Returns:
                the csm version as a string.
        Globals:
                $::PLTFRM
                $::RPMCMD
        Error:
                Undefined
        Example:
                 $ret_code=NodeUtils->get_CSMVersion("rpm");
        Comments:
                The version should be in the form "V.R.M" (e.g. 1.2.0).
                If showfixlevel parameter == true (1),  the version will be
                in the form "V.R.M.F" (e.g. 1.2.0.0). 

=cut

#--------------------------------------------------------------------------------

sub get_CSMVersion
{
    my ($class, $component, $showfixlevel) = @_;
    my ($cmd, $output, $rpm, $version, $release, $v1, $v2, $v3, $v4, $rest);

    if ($::PLTFRM eq "Linux")
    {
        $cmd    = "$::RPMCMD -q $component";
        $output = NodeUtils->runcmd($cmd);
        chomp($output);
        ($rpm, $version, $release) = split(/-/, $output);

        ($v1, $v2, $v3, $v4, $rest) = split(/\./, $version);
        if ($showfixlevel) { $version = join(".", $v1, $v2, $v3, $v4); }
        else { $version = join(".", $v1, $v2, $v3); }
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $cmd    = "$::LSLPP -cLq $component";
        $output = NodeUtils->runcmd($cmd);
        chomp($output);

        # The third field in the lslpp output is the VRMF
        ($version) = (split(/:/, $output))[2];

        ($v1, $v2, $v3, $v4, $rest) = split(/\./, $version);
        if ($showfixlevel) { $version = join(".", $v1, $v2, $v3, $v4); }
        else { $version = join(".", $v1, $v2, $v3); }
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }

    return (length($version) ? $version : undef);
}

#--------------------------------------------------------------------------------

=head3  get_default_attributes   

        Set these default values for attributes not on command line:

           InstallOSName                OS Name of management server ("Linux" or "AIX").
           InstallDistributionVersion   MS's operating system version.
           InstallDistributionName      MS's operating system distribution (Linux only)
           InstallPkgArchitecture       MS's architecture (Linux only).
                                             if MS's architecture=i?86:  set to i386..
           InstallCSMVersion            Version of csm.core installed on MS.
           ConsoleMethod                PowerMethod if PowerMethod=hmc.
           ConsoleServerName            Set to HWControlPoint if PowerMethod=hmc
                                             also set during -H and -C processing.
           ConsoleSerialDevice
           ConsolePortNum

        Arguments:
                none
        Returns:
               number of errors 
        Globals:
                $::ATTRS hash
        Error:
                error count
        Example:
                 NodeUtils->get_default_attributes;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_default_attributes
{
    my ($errors) = 0;

    # Operating System Type (Linux or AIX). Use MS's InstallOSName by default
    if (!$::ATTRS{"InstallOSName"})
    {
        $::ATTRS{"InstallOSName"} = InstallUtils->get_OSName();
        NodeUtils->message('V', 'IMsgDEFAULT_ATTR_SET', "InstallOSName",
                           $::ATTRS{'InstallOSName'});
        if (!$::ATTRS{"InstallOSName"})
        {
            NodeUtils->message('W', 'EMsgCANT_GET_OSNAME');
            $errors++;
        }

    }

    # Operating System Version.  Use MS's Operating System Version
    if (!$::ATTRS{"InstallDistributionVersion"})
    {
        $::ATTRS{"InstallDistributionVersion"} =
          InstallUtils->get_DistributionVersion();
        NodeUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
                           "InstallDistributionVersion",
                           $::ATTRS{'InstallDistributionVersion'});
        unless ($::ATTRS{"InstallDistributionVersion"})
        {
            NodeUtils->message('W', 'EMsgCANT_GET_DISTROVERSION');
            $errors++;
        }
    }

    # Operating System Distribution.  Use MS's Operating System Distribution.
    # Only for Linux.
    if (!$::ATTRS{"InstallDistributionName"}
        && ($::ATTRS{"InstallOSName"} eq "Linux"))
    {
        $::ATTRS{"InstallDistributionName"} =
          InstallUtils->get_DistributionName();
        NodeUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
                           "InstallDistributionName",
                           $::ATTRS{'InstallDistributionName'});
        unless ($::ATTRS{"InstallDistributionName"})
        {
            NodeUtils->message('W', 'EMsgCANT_GET_DISTRONAME');
            $errors++;
        }
    }

    # Package Architecture.  Use MS's Architecture.
    # Only for Linux.
    if (!$::ATTRS{"InstallPkgArchitecture"}
        && ($::ATTRS{"InstallOSName"} eq "Linux"))
    {
        $::ATTRS{"InstallPkgArchitecture"} =
          InstallUtils->get_PkgArchitecture();

        # All x86 machine types map to i386 since all x86 rpms are stored in
        # the same directory.
        if ($::ATTRS{'InstallPkgArchitecture'} =~ /i.86/)    #SSS
        {
            $::ATTRS{'InstallPkgArchitecture'} = "i386";
        }

        NodeUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
                           "InstallPkgArchitecture",
                           $::ATTRS{'InstallPkgArchitecture'});

        unless ($::ATTRS{"InstallPkgArchitecture"})
        {
            NodeUtils->message('W', 'EMsgCANT_GET_PKGARCH');
            $errors++;
        }
    }

    # CSM Version.  Use version of csm.core installed on MS by default for Linux
    if (   (!$::ATTRS{"InstallCSMVersion"})
        && ($::ATTRS{"InstallOSName"} eq "Linux"))
    {    # No default value for AIX nodes

        $::ATTRS{"InstallCSMVersion"} =
          InstallUtils->get_CSMVersion("csm.core");
        NodeUtils->message('V', 'IMsgDEFAULT_ATTR_SET', "InstallCSMVersion",
                           $::ATTRS{'InstallCSMVersion'});
        unless ($::ATTRS{"InstallCSMVersion"})
        {
            NodeUtils->message('W', 'EMsgCANT_GET_CSMVERSION');
            $errors++;
        }
    }

    # Console Serial Device.  For Linux, default to "ttyS0".
    if (   (!$::ATTRS{"ConsoleSerialDevice"})
        && ($::ATTRS{"InstallOSName"} eq "Linux"))
    {
        $::ATTRS{"ConsoleSerialDevice"} = "ttyS0";
    }

    # ConsoleMethod.  Set this to the PowerMethod if PowerMethod=hmc.
    if (!$::ATTRS{"ConsoleMethod"}
        and ($::ATTRS{"PowerMethod"} eq "hmc"))
    {
        $::ATTRS{"ConsoleMethod"} = $::ATTRS{"PowerMethod"};
    }

    # ConsoleServerName.  Set this to the HWControlPoint if PowerMethod=hmc.
    if (!$::ATTRS{"ConsoleServerName"}
        and ($::ATTRS{"PowerMethod"} eq "hmc"))
    {
        $::ATTRS{"ConsoleServerName"} = $::ATTRS{"HWControlPoint"};
    }

    #  If the PowerMethod is "csp" we can set some of the console attributes
    # ConsoleMethod.  Set this to the PowerMethod if PowerMethod=csp
    if (!$::ATTRS{"ConsoleMethod"} and ($::ATTRS{"PowerMethod"} eq "csp"))
    {
        $::ATTRS{"ConsoleMethod"} = $::ATTRS{"PowerMethod"};
    }

    # ConsoleServerName.  Set this to the HWControlPoint if PowerMethod=csp
    if (!$::ATTRS{"ConsoleServerName"} and ($::ATTRS{"PowerMethod"} eq "csp"))
    {
        $::ATTRS{"ConsoleServerName"} = $::ATTRS{"HWControlPoint"};
    }

    # ConsolePortNum. Set this to the HWControlNodeId if PowerMethod=csp
    if (!$::ATTRS{"ConsolePortNum"} and ($::ATTRS{"PowerMethod"} eq "csp"))
    {
        $::ATTRS{"ConsolePortNum"} = $::ATTRS{"HWControlNodeId"};
    }

    return ($errors);
}

#--------------------------------------------------------------------------------

=head3    get_DistributionName

        Linux only command
        
        Get the distribution name for Linux 

        Arguments:
                 $output
                 $rpm
                 $distro
        Returns:
                Linux distribution name as a string.
        Globals:
                $::PLTFRM
        Error:
                Exits with E2
        Example:
                $::ATTRS{'InstallDistributionName'} =
                        NodeUtils->get_DistributionName;
        Comments:
                returns nulls for AIX and exits on E2 for any
                other platform.

=cut

#--------------------------------------------------------------------------------

sub get_DistributionName
{
    my ($cmd, $output, $rpm, $distro);

    # IF LINUX
    if ($::PLTFRM eq "Linux")
    {
        $distro = (split ' ', (NodeUtils->distribution()))[0];

        #if (-f '/etc/redhat-release')
        #{
        # RedHat is the only Linux distro we support for now.
        #    $distro = "RedHat";
        #}
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $distro = "";
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }

    return (length($distro) ? $distro : undef);
}

#--------------------------------------------------------------------------------

=head3    get_DistributionVersion

        Returns the Operating System version that is installed on the
        management server.

        Arguments:
                none
        Returns:
                OS Version as a string.
        Globals:
                $::PLTFRM
        Error:
                undef
        Example:
                my $DistVersion = 
                        NodeUtils->get_DistributionVersion();
        Comments:
                For AIX, the version is in the V.R.M form ( e.g. 1.2.0 ).
                For Linux, the form reported in the /etc/redhat-release file
                (V.R) is used ( e.g. 1.2 )

=cut

#--------------------------------------------------------------------------------

sub get_DistributionVersion
{
    my ($cmd, $output, $rpm, $version, $release, $v1, $v2, $v3, $rest);

    if ($::PLTFRM eq "Linux")
    {

        $version = (split ' ', (NodeUtils->distribution()))[1];

        #if (-f '/etc/redhat-release')
        #{
        #    my $s = NodeUtils->readFile('/etc/redhat-release');
        #    ($version) = $s =~ /\s(\d+\.\d+)\s/;
        #}
    }
    elsif ($::PLTFRM eq "AIX")
    {

        #$cmd = "$::OSLEVEL";
        $cmd    = "$::LSLPP -Lcq bos.rte | /usr/bin/cut -d: -f 3";
        $output = NodeUtils->runcmd($cmd);
        chomp($output);

        ($v1, $v2, $v3, $rest) = split(/\./, $output);
        $version = join(".", $v1, $v2, $v3);
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }

    return (length($version) ? $version : undef);
}

#--------------------------------------------------------------------------------

=head3    get_OSName

        Returns the OS Name i.e. Linux, AIX or undef.

        Arguments:
                none
        Returns:
                OS Name as a string.
        Globals:
                none
        Error:
                undef
        Example:
                $::ATTRS{'InstallOSName'}=NodeUtils->get_OSName;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_OSName
{
    if (NodeUtils->isLinux() == 1)
    {
        return "Linux";
    }
    elsif (NodeUtils->isAIX() == 1)
    {
        return "AIX";
    }
    return undef;
}

#--------------------------------------------------------------------------------

=head3    get_PkgArchitecture

        Linux only routine.

        Returns the rpm package architure for the OS in $::PLTFRM
        i.e. i386 for linux

        Arguments:
                $output,
                $osarch
        Returns:
                none
        Globals:
                $::PLTFRM
        Error:
                messageFromCat E2
        Example:
                $::ATTRS{'InstallPkgArchitecture'} =
                        NodeUtils->get_PkgArchitecture;
        Comments:
                Works for Linux.  Returns null values $::PLTFRM
                is AIX, and exits with E2 for any other $::PLTFRM. 

=cut

#--------------------------------------------------------------------------------

sub get_PkgArchitecture
{
    my ($cmd, $output, $osarch);
    if ($::PLTFRM eq "Linux")
    {
        $cmd    = "$::UNAME -m";
        $output = NodeUtils->runcmd($cmd);
        chomp($output);

        $osarch = $output;

        return (length($osarch) ? $osarch : undef);
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $osarch = "";
        return (length($osarch) ? $osarch : undef);
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }
}

#--------------------------------------------------------------------------------

=head3    get_pkgVersion

        AIX only routine.

        Returns the installp image version from Installp command which,
        looks into the .toc file.

        Arguments:
                $installpPackage
        Returns:
                AIX installp image version as a string
        Globals:
                $::PLTFRM
                $::INSTALLPCMD
        Error:
                messageFromCat E2
        Example:
                not used outside NodeUtils
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_pkgVersion
{
    my ($class, $pkg) = @_;
    my ($cmd, $output, $version);

    if ($::PLTFRM eq "Linux")
    {
        $version = "";
        return (length($version) ? $version : undef);
    }
    elsif ($::PLTFRM eq "AIX")
    {
        $cmd    = qq($::INSTALLPCMD -L -d . | grep $pkg 2>&1);
        $output = NodeUtils->runcmd($cmd);
        chomp($output);
        (undef, undef, $version, undef) = split(/:/, $output);
        return (length($version) ? $version : undef);
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }

}

#--------------------------------------------------------------------------------

=head3    getSetupKRB5                                                       #

        Gets or sets up KRB5 for a Management Server Node. 

        Arguments:
               none
        Returns:
                1 on failure
        value of attribute on success
        Globals:
                none
        Error:
                none
        Example:
                 my $krb5setup = NetworkUtils->getSetupKRB5();
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getSetupKRB5
{

    # set local scope because we only want classes on the mgmt svr
    $ENV{'CT_MANAGEMENT_SCOPE'} = 1;

    # todo: remove when lsrsrc-api converts to above
    $ENV{'CT_SESSION_SCOPE'} = 1;
    if (NodeUtils->isMgmtSvr())
    {    #only defined on managment server
        my $outref =
          NodeUtils->runrmccmd('lsrsrc-api', "-i",
                               "-s IBM.DmsCtrl::::SetupKRB5");
        return $$outref[0];
    }
    return 1;
}

#--------------------------------------------------------------------------------

=head3    listNodeAttrs


        Return attribute values for a given array of node names.

        Before calling this function, you can optionally call gatherNodeList()
        to build the array of node names from user input.

        You can also optionally call resolveAndUndup() separately, if you need
        access to the resolved list.

        Arguments:
           arrayref    A reference to the array containing the list of nodes.
                       If the list is empty and the WhereStr option is not
                       specified, all the nodes in the ManagedNode class 
                       will be selected.
           attrs       list of attributes that should be returned.
                       Multiple attribute names can be separate by spaces
                       and/or commas.
           opthashref  A reference to a hash with the following options:

                WhereStr:          A where string to use instead of a nodeList.
                IncludeAttrNames:  set to 1 if you want the attribute name to
                                   precede each attribute value.
                SkipResolve:       set to 1 if this function should not do name
                                   resolution on the list of nodes and remove
                                   duplicates.  If you set this to 1, you must
                                   also pass in Res2Unres below.
                Res2Unres:         reference to the hash returned by
                                   resolveAndUndup().
                ResourceClass:     resource class to get the node info from.
                                   Default is IBM.ManagedNode.  Make sure the
                                   environment variable CT_MANAGEMENT_SCOPE is
                                   set appropriately for the class being used
                                   (for IBM.ManagedNode it should be 1).
        Returns:
         Returns a reference to an array in which each line will contain
         the attributes for 1 node, separated by :|:

         Also $::LISTNODEATTRS_NUMNOTFOUND will be set to the number of nodes that
         were specified, but not found.
        Globals:
         $::LISTNODEATTRS_NUMNOTFOUND will be set to the number of nodes specified
        Error:
                none
        Example:
                none 
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub listNodeAttrs
{
    my ($class, $arrayref, $attrs, $opthashref) = @_;

    # Process the select argument
    if (length($attrs))
    {
        $attrs =~ s/[, ]+/::/g;
    }    # lsrsrc-api needs the attrs separated by ::
    else
    {
        $attrs = "'*b0x0020'";
    }    # this means return all public attributes

    # Set up where string
    my ($where, $whereattr, $ar2, $res2unres, $dontstripnameattr);

    if ($$opthashref{'ResourceClass'} eq 'IBM.Host')
    {
        $whereattr = 'NodeNameList';
    }
    elsif ($$opthashref{'ResourceClass'} eq 'IBM.DeviceHwCtrl')
    {
        $whereattr = 'Name';
    }

    my $numtobefound = 0;    # 0 means we do not know, i.e. a where string
    if (defined($$opthashref{'WhereStr'}))
    {
        $where = NodeUtils->quote($$opthashref{'WhereStr'});
    }
    elsif (defined($arrayref) && scalar(@$arrayref))
    {
        if ($$opthashref{'SkipResolve'})
        {
            $ar2 = $arrayref;
            if (!defined($$opthashref{'Res2Unres'}))
            {
                if (!$NodeUtils::NO_MESSAGES)
                {
                    NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
                                              'W', 'EMsgNO_RES2UNRES');
                }
                $NodeUtils::errno = 33;
                $res2unres        = {};
            }
            else { $res2unres = $$opthashref{'Res2Unres'}; }
        }
        else
        {
            ($ar2, $res2unres) = NodeUtils->resolveAndUndup($arrayref);
        }
        $where             = NodeUtils->buildWhereInList($ar2, $whereattr);
        $numtobefound      = scalar(@$ar2);
        $dontstripnameattr = $attrs =~ /(^|::)Name(::|$)/;
        if (!$dontstripnameattr) { $dontstripnameattr = $attrs =~ /\*(b|p)/; }
        if ($$opthashref{'ResourceClass'} eq 'IBM.Host')
        {
            $attrs = "NodeNameList::$attrs";
        }
        else
        {
            $attrs = "Name::$attrs";
        }    # prepend the Name attr so we can tell which ones were found
    }
    else { $where = ''; }    # this will pick up everything

    # Process other options and run lsrsrc-api cmd
    my $outputFormat = "-D ':|:'";
    my $longFormat   = 0;
    if ($$opthashref{'IncludeAttrNames'})
    {
        $outputFormat .= ' -n';
        $longFormat = 1;
    }
    my $resclass = $$opthashref{'ResourceClass'} || 'IBM.ManagedNode';
    my $exitcode = $$opthashref{'ExitCodeBehavior'} || -2;
    my $numfound = 0;
    my $outref   =
      NodeUtils->runrmccmd(
                           'lsrsrc-api',
                           "$outputFormat -i",
                           "-s ${resclass}::${where}::$attrs",
                           $exitcode
                           );

    # $exitcode defines exitcode behavior if cmd encounters error
    # Values are the same as defined for runcmd
    # Default is -2 (runrmccmd will exit if the cmd fails)
    $numfound = scalar(@$outref);
    my $somenotfound = ($numtobefound && $numfound < $numtobefound);

    # Strip the Name attr from the front and figure out which nodes were not found (if applicable)
    if ($numtobefound)
    {
	my $namefound = 0; #looking for Name attribute, 
	#lsrsrc-api only returns 1 value per attribute, even if attribute apears more than once in the string. 
	if($dontstripnameattr){ #locate the Name attribute in the string, so we can put it back in the right place
	    my @vals = split /::/, $attrs;
	    my $i =0;
	    shift @vals; #Name is the first one
	    foreach my $v (@vals){
		if($v eq "Name"){
		    $namefound = $i;
		    last;
		}
		$i++;
	    }
	}
	foreach my $l (@$outref)
        {
	    # Get the Name attribute and strip it from the beginning of the line
            my ($junk, $name, $rest);
            if ($longFormat) { ($junk, $name, $rest) = split(/:\|:/, $l, 3); }
            else { ($name, $rest) = split(/:\|:/, $l, 2); }
            if (!$dontstripnameattr) { $l = $rest; } #this strips the Name
	    elsif(($namefound != 0) && (!$longFormat)){ #found the Name attribute
		my @values = split /:\|:/, $rest;
		splice @values, $namefound, 0, $name;
		$l = join ":|:", @values;
	    }
	    # Remove this node from the hash so we do not try to get it again
            if ($somenotfound) { delete $$res2unres{$name}; }
        }
    }

    if ($somenotfound)    # some of the specified nodes were not found
    {

        # The only thing left in the hash are the nodes we did not find.  Build
        # the array of unresolved node names and try those
        my @a;
        foreach my $k (keys %$res2unres)
        {
            if ($k ne "" && $k ne $$res2unres{$k})
            {
                push @a, @{$$res2unres{$k}};
            }
        }
        if (scalar(@a))
        {
            $where = NodeUtils->buildWhereInList(\@a, $whereattr);
            $attrs =~ s/^Name:://;
            my $outref2 =
              NodeUtils->runrmccmd(
                                   'lsrsrc-api',
                                   "$outputFormat -i",
                                   "-s ${resclass}::${where}::$attrs"
                                   );
            $numfound += scalar(@$outref2);
            push @$outref, @$outref2;    # append this to the 1st
        }
        $::LISTNODEATTRS_NUMNOTFOUND = $numtobefound - $numfound;
    }
    else                                 # everything found
    {
        $::LISTNODEATTRS_NUMNOTFOUND = 0;
    }

    return $outref;
}

#--------------------------------------------------------------------------------

=head3    SetAllowRequest

        Make sure the management server can update the node information.

        Arguments:
                $ref_DestNodeHash
                $value
        Returns:
                0 - All was successful
                1 - An error occured.
        Error:
                $::NOK
        Example:
                # Turn on ability of a node to request itself managed.
                NodeUtils->SetAllowRequest(\%nodehash, '1');
        Comments:
                Value should be set to 3 by installnode and by updatenode if
                the Mode is not managed.   Otherwise it should be set to 2 by
                updatenode.  During updatenode exit, it should be set to 0. 

=cut

#--------------------------------------------------------------------------------

sub SetAllowRequest
{

    my ($class, $ref_DestNodeHash, $value) = @_;
    my %DestNodeHash = %$ref_DestNodeHash;
    if (!$value)
    {
        $value = "0 ";
    }
    if (keys %DestNodeHash)
    {

        # DestNodeHash is a hash containing attribute values for
        # each node that was provided on the command line.
        my ($cmd, $rc);

        # check each node on our list and set the AllowManageRequest
        # attribute if needed.
        my @nodelist = (keys %DestNodeHash);

        my $nodelist_file = InstallUtils->make_node_list_file(\@nodelist);
        $cmd = "$::CHNODE -f $nodelist_file AllowManageRequest=$value";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E',
                                      'EMsgCMD_FAILED_RC', "$cmd",
                                      $rc
                                      );
        }
        InstallUtils->close_delete_file($::NODE_LIST_FILE, $nodelist_file);
        return $::OK;

    }
    else
    {
        return 1;    #a value and nodes must be specified.
    }
}

#--------------------------------------------------------------------------------

=head3    SetControlFlag

        Set the ControlFlag attribute.  Currently, this is used to
        determine whether the node is allowed to write to the status
        log in /csminstall/csm/status/<nodename>.

        Arguments:
                $ref_DestNodeHash
                $value
        Returns:
                $::OK
                1 on error
        Error:
                1 on error
        Example:
                # Turn on ability of a node to write to status file
                NodeUtils->SetControlFlag(\%nodehash, '1');
        Comments:
                $value should be set to 1 by installnode, and then  csmfirstboot
                will run an RMC action to set it back to 0 when the node install is
                complete and no more status messages need to be written to the MS.

=cut

#--------------------------------------------------------------------------------

sub SetControlFlag
{

    my ($class, $ref_DestNodeHash, $value) = @_;
    my %DestNodeHash = %$ref_DestNodeHash;
    if (!$value)
    {
        $value = "0 ";
    }
    if (keys %DestNodeHash)
    {

        # DestNodeHash is a hash containing attribute values for
        # each node that was provided on the command line.
        my ($cmd, $rc);
        my @nodelist = (keys %DestNodeHash);

        my $nodelist_file = InstallUtils->make_node_list_file(\@nodelist);
        $cmd = "$::CHNODE -f $nodelist_file ControlFlag=$value";
        $rc  = system("$cmd");
        if ($rc >> 8)
        {
            NodeUtils->messageFromCat(
                                      'csmInstall.cat',    $::MSGMAPPATH,
                                      'csminstall',        'E',
                                      'EMsgCMD_FAILED_RC', "$cmd",
                                      $rc
                                      );
        }
        InstallUtils->close_delete_file($::NODE_LIST_FILE, $nodelist_file);
        return $::OK;

    }
    else
    {
        return 1;    #a value and nodes must be specified.
    }
}

#--------------------------------------------------------------------------------

=head3    SetMode

        Set a node's Mode attribute to PreManaged, Installing or Managed.

        Arguments:
                $node,
                $mode
        Returns:
                Status code from chnode()
        Globals:
                $::CSMLITE
        Example:
                $rc = NodeUtils->SetMode($node, $mode);_
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub SetMode
{
    my ($class, $node, $mode) = @_;
    my ($cmd, $rc, $fstatus);

    my $CSMLITE = $::CSMLITE;
    if (    ($mode ne "PreManaged")
        and ($mode ne "Installing")
        and ($mode ne "Managed")
        and ($mode ne $CSMLITE)
        and ($mode ne "${CSMLITE}-Installing"))
    {
        NodeUtils->messageFromCat(
              'csmInstall.cat',
              $::MSGMAPPATH,
              'csminstall',
              'E1',
              'EMsgINVALID_MODE',
              $mode,
              "PreManaged, Installing, Managed, $CSMLITE, ${CSMLITE}-Installing"
              );
    }

    $cmd = "$::CHNODE $node Mode=$mode";
    $rc  = system($cmd) >> 8;
    if ($rc != 0)
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E', 'EMsgCMD_FAILED_RC', $::CHNODE, $rc);
        $fstatus = $rc;
    }

    return $fstatus;
}

#--------------------------------------------------------------------------------

=head3    testvalidconsole

        Checks for the valid Console Method attributes. This subroutine 
        compares the given Console method against the list in the
        /opt/csm/bin/*_console Console methods.

        Arguments:
                ConsoleMethod attribute value as a string
        Returns:
                0 - valid console
                1 - not a valid console
                2 - error running ls on /opt/csm/bin
        Globals:
                none
        Error:
                1 or 2
        Example:
                 $retCode =
                    NodeUtils->testvalidconsole($::ATTRS{"ConsoleMethod"});
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub testvalidconsole
{
    my ($class, $my_console) = @_;
    my @temp_console = ();
    @::valid_console = ();
    my $console     = "";
    my $tmp_console = "";
    @temp_console = NodeUtils->runcmd("$::LS \/opt\/csm\/bin\/\*_console", -1);
    if ($::RUNCMD_RC != 0)
    {
        return 2;
    }
    foreach $tmp_console (@temp_console)
    {
        (undef, undef, undef, undef, $console) = split("/", $tmp_console);
        ($console, undef) = split("_", $console);
        push(@::valid_console, $console);
    }
    if (!grep(/^$my_console$/, @::valid_console))
    {
        return 1;
    }
    else
    {
        return 0;
    }
}

#--------------------------------------------------------------------------------

=head3    testvalidpowermethod

        Checks for the valid Power Method attributes.

        Arguments:
                $powerMethod as a string
        Returns:
                0 - valid power method
                1 - not valid
        Globals:
                none
        Error:
                1
        Example:
                $retCode =
                   NodeUtils->testvalidpowermethod($::ATTRS{"PowerMethod"});
        Comments:
                This subroutine  compares the given Power method against the one in
                the /opt/csm/lib/lib+<given Power Method>+_power.so. If this Method
                is not found then it checks against the value in  /opt/csm/bin/*_power
                for a power command shipped with csm. If not found there then it
                checks against the value in  /opt/local/*_power.

=cut

#--------------------------------------------------------------------------------

sub testvalidpowermethod
{
    my ($class, $my_powermethod) = @_;
    my @temp_powermethod = ();
    @::valid_powermethod = ();
    my $powermethod     = "";
    my $tmp_powermethod = "";
    my $exit_code       = 0;
    @temp_powermethod = ();
    @temp_powermethod =
      NodeUtils->runcmd("$::LS \/opt\/csm\/lib\/\*_power\.so", -1);

    if ($::RUNCMD_RC != 0)
    {
        $exit_code = 2;
    }
    else
    {
        foreach $tmp_powermethod (@temp_powermethod)
        {
            if (-z $tmp_powermethod)
            {
                next;
            }
            $powermethod = basename($tmp_powermethod);
            $powermethod =~ s/^lib(.*)_power.*$/$1/;
            push(@::valid_powermethod, $powermethod);
        }
        if (!grep(/^$my_powermethod$/, @::valid_powermethod))
        {
            $exit_code = 1;
        }
        else
        {
            $exit_code = 0;
        }
    }
    if (($exit_code == 1) || ($exit_code == 2))
    {
        @temp_powermethod = ();
        @temp_powermethod =
          NodeUtils->runcmd("$::LS \/opt\/csm\/bin\/\*_power", -1);
        if ($::RUNCMD_RC != 0)
        {

            #$exit_code=2;
        }
        else
        {
            foreach $tmp_powermethod (@temp_powermethod)
            {
                if (-z $tmp_powermethod)
                {
                    next;
                }
                $powermethod = basename($tmp_powermethod);
                $powermethod =~ s/(.*)_power.*$/$1/;
                push(@::valid_powermethod, $powermethod);
            }

            if (!grep(/^$my_powermethod$/, @::valid_powermethod))
            {
                $exit_code = 1;
            }
            else
            {
                $exit_code = 0;
            }
        }
    }
    if (($exit_code == 1) || ($exit_code == 2))
    {
        @temp_powermethod = ();
        @temp_powermethod =
          NodeUtils->runcmd("$::LS \/opt\/local\/\*_power", -1);
        if ($::RUNCMD_RC != 0)
        {

            #$exit_code=2;
        }
        else
        {
            foreach $tmp_powermethod (@temp_powermethod)
            {
                if (-z $tmp_powermethod)
                {
                    next;
                }
                $powermethod = basename($tmp_powermethod);
                $powermethod =~ s/(.*)_power.*$/$1/;
                push(@::valid_powermethod, $powermethod);
            }

            if (!grep(/^$my_powermethod$/, @::valid_powermethod))
            {
                $exit_code = 1;
            }
            else
            {
                $exit_code = 0;
            }
        }
    }
    return $exit_code;
}

#--------------------------------------------------------------------------------

=head3	verify_linux_attribute_definitions

	Linux only.

    	Check if all the attributes are there, if not defined then get the default
	from Management Server.  Does a fairly loose test of the values that the 
	attributes have been assigned and will generate an error if it finds
	an incorrect value.  


	Attributes tested are:

	.  InstallOSName
	.  InstallCSMVersion
	.  InstallDistributionName
	.  InstallDistributionVersion
	.  InstallPkgArchetecture
	
	Arguments:
        	none
	Returns:
		undef
	Globals:
		$::ATTRS
		$::PLTFRM
		@::VALID_DISTROS
		@::VALID_CSM_DISTROS
		@::DISTRO
	Error:
		Multiple E1 error messages
	Example:
		NodeUtils->verify_linux_attribute_definitions();
	Comments:
		rewritten for defect 10100

=cut

#--------------------------------------------------------------------------------

sub verify_linux_attribute_definitions
{

    #  Get defaults if the attributes aren't defined

    if (!($::ATTRS{'InstallOSName'}))
    {
        $::ATTRS{'InstallOSName'} = NodeUtils->get_OSName;
    }
    if (!($::ATTRS{'InstallCSMVersion'}))
    {
        $::ATTRS{'InstallCSMVersion'} = NodeUtils->get_CSMVersion("csm\.core");
    }
    if (!($::ATTRS{'InstallDistributionName'}))
    {
        $::ATTRS{'InstallDistributionName'} = NodeUtils->get_DistributionName;
    }
    if (!($::ATTRS{'InstallDistributionVersion'}))
    {
        $::ATTRS{'InstallDistributionVersion'} =
          NodeUtils->get_DistributionVersion;
    }
    if (!($::ATTRS{'InstallPkgArchitecture'}))
    {
        $::ATTRS{'InstallPkgArchitecture'} = ArchiveUtils->get_PkgArchitecture;
    }

    # AIX is not supported - get it out of the routine.
    if (($::ATTRS{'InstallOSName'} eq "AIX") || ($::PLTFRM eq "AIX"))
    {
        MessageUtils->message('E', 'EMsgCopyingAIXpkgs');
        exit 1;
    }

    # Test InstallOSName
    if ($::ATTRS{'InstallOSName'} ne "Linux")
    {
        MessageUtils->message("E2", 'EMsgINVALID_OSTYPE');
    }

    # Test platform
    if ($::PLTFRM ne "Linux")
    {
        MessageUtils->message("E2", 'EMsgINVALID_OSTYPE');
    }

    # Test InstallDistributionName / InstallDistributionVersion
    my $temp_distro =
        $::ATTRS{'InstallDistributionName'} . " "
      . $::ATTRS{'InstallDistributionVersion'};

    if (!grep(/^$temp_distro$/, @::VALID_DISTROS))
    {
        MessageUtils->message('W', 'EMsgUNSUPPORTED_DISTRO',
                              $temp_distro, join(', ', @::VALID_DISTROS));
    }
    else
    {
        $::DISTRO = $temp_distro;
        MessageUtils->message('V', 'IMsgDETECTED_DISTRO', $temp_distro);
    }

    # Test InstallPkgArchitecture
    if ($::ATTRS{'InstallPkgArchitecture'} =~ /i.86/)
    {
        $::ATTRS{'InstallPkgArchitecture'} = "i386";
    }
    elsif ($::ATTRS{'InstallPkgArchitecture'} eq "ppc64")
    {

        #  hip hip, hurrah!
    }elsif($::ATTRS{'InstallPkgArchitecture'} eq "x86_64"){
	#  hahehi 
    }else { MessageUtils->message('E1', 'EMsgNoArch'); }

    # Test InstallCSMVersion
    if (length($::ATTRS{'InstallCSMVersion'}) == 0)
    {
        MessageUtils->message('E2', 'EMsgNO_CORE_COPY');
    }
    if (!grep(/^$::ATTRS{'InstallCSMVersion'}$/, @::VALID_CSM_DISTROS))
    {
        MessageUtils->message(
                              'E5',
                              'EMsgUNSUPPORTED_CSM_DISTRO',
                              "CSM" . $::ATTRS{'InstallCSMVersion'},
                              join(', ', @::VALID_CSM_DISTROS)
                              );
    }
    else
    {
        MessageUtils->message(
                              'V',
                              'IMsgDETECTED_CSM_DISTRO',
                              "CSM" . $::ATTRS{'InstallCSMVersion'}
                              );
    }
}


#--------------------------------------------------------------------------------

=head2    Messaging 

           The NodeUtils messageing subroutines have been moved to their own package:

        MessageUtils.pm

    Please do not add messaging subroutines to NodeUtils.

=cut

#--------------------------------------------------------------------------------

=head3    getMessage
    

    MessageUtils->getMessage

=cut

sub getMessage { shift; return MessageUtils->getMessage(@_); }

#--------------------------------------------------------------------------------

=head3    getMessageFromCat
    

    MessageUtils->getMessageFromCat

=cut

sub getMessageFromCat { shift; return MessageUtils->getMessageFromCat(@_); }

#--------------------------------------------------------------------------------

=head3    getmsg 
    

    MessageUtils->getmsg

=cut

sub getmsg { shift; return MessageUtils->getmsg(@_); }

#--------------------------------------------------------------------------------

=head3    getmsgmap

    MessageUtils->getmsgmap

=cut

sub getmsgmap { shift; return MessageUtils->getmsgmap(@_); }

#--------------------------------------------------------------------------------

=head3    msg

    MessageUtils->msg

=cut

sub msg { shift; return MessageUtils->msg(@_); }

#--------------------------------------------------------------------------------

=head3    message

    MessageUtils->message

=cut

sub message { shift; return MessageUtils->message(@_); }

#--------------------------------------------------------------------------------

=head3    messageFromCat

    MessageUtils->messageFromCat

=cut

sub messageFromCat { shift; return MessageUtils->messageFromCat(@_); }

#--------------------------------------------------------------------------------

=head3    processNewlines

    MessageUtils->processNewlines

=cut

sub processNewlines { shift; return MessageUtils->processNewlines(@_); }

#--------------------------------------------------------------------------------

=head3    substituteValues

    MessageUtils->substituteValues

=cut

sub substituteValues { shift; return MessageUtils->substituteValues(@_); }

#--------------------------------------------------------------------------------

=head3    useTranslatedMsg

    MessageUtils->useTranslatedMsg

=cut

sub useTranslatedMsg { shift; return MessageUtils->useTranslatedMsg(@_); }

#--------------------------------------------------------------------------------

=head2    Run Command Tools

=head3    filterRmcApiOutput

    filter RMC Api Output

    Arguments:
        RMC command
        Output reference
    Returns:
        none
    Globals:
        none
    Error:
        none
    Example:
         NodeUtils->filterRmcApiOutput($cmd, $outref); 
    Comments:
        The error msgs from the RPM -api cmds are pretty messy.
        This routine cleans them up a little bit.

=cut

#--------------------------------------------------------------------------------

sub filterRmcApiOutput
{
    my ($class, $cmd, $outref) = @_;
    if ($::VERBOSE || !($cmd =~ m|^/usr/bin/\S+-api |))
    {
        return;
    }    # give as much info as possible, if verbose

    # Figure out the output delimiter
    my ($d) = $cmd =~ / -D\s+(\S+)/;
    if (length($d))
    {
        $d =~ s/^(\'|\")(.*)(\"|\')$/$2/;    # remove any surrounding quotes
        $d =~ s/([\|\^\*\+\?\.])/\\$1/g
          ; # escape any chars perl pattern matching would intepret as special chars
    }
    else
    {
        $d = '::';
    }    # this is the default output delimiter for the -api cmds
         #$$outref[0] =~ s/^ERROR:\|:.*:\|:.*:\|:.*:\|:.*:\|://;
         #print "d=$d.\n";
    $$outref[0] =~ s/^ERROR${d}.*${d}.*${d}.*${d}.*${d}//;
}

#--------------------------------------------------------------------------------

=head3    runcmd

    Run the given cmd and return the output in an array (already chopped).  Alternatively,
    if this function is used in a scalar context, the output is joined into a single string
    with the newlines separating the lines.  

    Arguments:
        command, exitcode and reference to output
    Returns:
        see below
    Globals:
        $::RUNCMD_RC
    Error:
        Normally, if there is an error running the cmd, it will display the error msg
        and exit with the cmds exit code, unless exitcode is given one of the
        following values:
             0:     display error msg, DO NOT exit on error, but set
                $::RUNCMD_RC to the exit code.
            -1:     DO NOT display error msg and DO NOT exit on error, but set
                $::RUNCMD_RC to the exit code.
            -2:    DO the default behavior (display error msg and exit with cmds
                exit code.
        number > 0:    Display error msg and exit with the given code
    Example:
        my $outref = NodeUtils->runcmd($cmd, -2, 1);     
    Comments:
        If refoutput is true, then the output will be returned as a reference to
        an array for efficiency.

=cut

#--------------------------------------------------------------------------------

sub runcmd
{
    my ($class, $cmd, $exitcode, $refoutput) = @_;
    $::RUNCMD_RC = 0;
    if (!($cmd =~ /2>&1$/)) { $cmd .= ' 2>&1'; }
    if (!$NodeUtils::NO_MESSAGES)
    {
        NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V', 'IMsgCMD',
                                  $cmd);
    }
    my $outref = [];
    @$outref = `$cmd`;
    if ($?)
    {
        $::RUNCMD_RC = $? >> 8;
        my $displayerror = 1;
        my $rc;
        if (defined($exitcode) && length($exitcode) && $exitcode != -2)
        {
            if ($exitcode > 0)
            {
                $rc = $exitcode;
            }    # if not zero, exit with specified code
            elsif ($exitcode <= 0)
            {
                $rc = '';    # if zero or negative, do not exit
                if ($exitcode < 0) { $displayerror = 0; }
            }
        }
        else
        {
            $rc = $::RUNCMD_RC;
        }    # if exitcode not specified, use cmd exit code
             #print "rc=$rc\n";
        if ($displayerror)
        {
            my $errmsg = '';
            if (NodeUtils->isLinux() && $::RUNCMD_RC == 139)
            {
                $errmsg = "Segmentation fault  $errmsg";
            }
            else
            {
                NodeUtils->filterRmcApiOutput($cmd, $outref)
                  ; # The error msgs from the -api cmds are pretty messy.  Clean them up a little.
                $errmsg = join('', @$outref);
                chomp $errmsg;
            }
            if (!$NodeUtils::NO_MESSAGES)
            {
                NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, "E$rc",
                                 'EMsgCMD_FAILED', $::RUNCMD_RC, $cmd, $errmsg);
            }
            $NodeUtils::errno = 29;
        }

        #return undef;    # if rc was set msg() will exit, otherwise return output
    }
    if ($refoutput)
    {
        chomp(@$outref);
        return $outref;
    }
    elsif (wantarray)
    {
        chomp(@$outref);
        return @$outref;
    }
    else
    {
        my $line = join('', @$outref);
        chomp $line;
        return $line;
    }
}

#--------------------------------------------------------------------------------

=head3    run_cmd

        Run a system command

        Arguments:
               
            The first argument is a string containing the command to run.

            The second argument is the type of message that should be printed.
                Valid values for msgtype are:  E, W, I, etc.  (same as the msg
                    routine) If msgtype is "E" (the default), the command exits
                    the program with the return code of the command.

                The third argument specifies how the command will run.

        Returns:
                Return code from the shell executing the commmand.
        Globals:
                none
        Error:
            If msgtype is "E" (the default), the command exits the program
        with the return code of the command.

                If runtype is "show_errors" or not specified, stdout will be captured
                and displayed in a message as specified by msgtype.

                If runtype is "show_all", all output will go be sent to stdout or
                wherever the command sends it.  Any errors will be displayed as a
                message as specified by msgtype.

                If runtype is "ignore_errors", all output will go be sent to the
                screen or wherever the command sends it.  Any errors will be ignored.

        Example:
                 NodeUtils->run_cmd($cmd, "W", "ignore_errors");
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub run_cmd
{
    my ($class, $cmd, $msgtype, $runtype) = @_;
    my ($rc, @cmdout, $msgtypestr);

    $msgtype = "E"           if (!$msgtype);
    $runtype = "show_errors" if (!$runtype);

    NodeUtils->message('V', 'IMsgCMD', $cmd);
    if ($runtype eq "show_all")
    {
        $rc = system("$cmd") >> 8;
        if ($rc)
        {

            # Only exit with a return code if msgtype = "E" (Error)
            $msgtypestr = $msgtype;
            $msgtypestr = "$msgtype$rc" if ($msgtype eq "E");
            NodeUtils->message("$msgtypestr", 'EMsgCMD_FAILED_RC', $cmd, $rc);
        }
    }
    elsif ($runtype eq "show_errors")
    {
        @cmdout = `$cmd 2>&1`;
        chomp(@cmdout);    # take the newline off
        $rc = $? >> 8;

        if ($rc)
        {

            # Only exit with a return code if msgtype = "E" (Error)
            $msgtypestr = $msgtype;
            $msgtypestr = "$msgtype$rc" if ($msgtype eq "E");

            NodeUtils->message("$msgtypestr", 'EMsgCMD_FAILED',
                               $cmd, join('', @cmdout));
        }
    }
    elsif ($runtype eq "ignore_errors")
    {
        $rc = system("$cmd") >> 8;
    }
    else
    {
        NodeUtils->message('E1', 'EMsgRUN_CMD_INVALID', $runtype);
    }

    return $rc;
}

#--------------------------------------------------------------------------------

=head3    runrmccmd

    Runs an RMC commmand

    Arguments:
        $rmccmd, $resclass, $options, $select
    Returns:
        the output from  NodeUtils->runcmd($cmd, -2, 1)
        as a ref to the output array.
    Globals:
        none
    Error:
        none
    Example:
         my $outref =
            NodeUtils->runrmccmd('lsrsrc-api', "-i -D ':|:'", $where);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub runrmccmd
{

    #my ($class, $rmccmd, $resclass, $options, $select) = @_;
    my ($class, $rmccmd, $options, $select, $exitcode) = @_;
    my $cmd = "/usr/bin/$rmccmd $options $select";
    if (!defined($exitcode))
    {
        $exitcode = -2;
    }

    return NodeUtils->runcmd($cmd, $exitcode, 1)
      ;    # returns a reference to the output array
}

#--------------------------------------------------------------------------------

=head2    Node & Group Support


=cut

#--------------------------------------------------------------------------------

=head3    add_cluster_nl

    Get hosts currently in CSM and adds to the node list.  
    Routine uses $main::lsnodes_opt as the flag to lsnodes command.

    This description doesn't make much sense.  Maybe someone will
    rewrite it.

    Arguments:
        none
    Returns:
        none
    Globals:
        $main::lsnodes_opt
    Error:
        Prints to STDERR.
    Example:
        not used
    Comments:
        not used??

=cut

#--------------------------------------------------------------------------------

sub add_cluster_nl
{

    my ($hostname, @hostnames);
    my $optcsmdir = "/opt/csm/bin";

    if (!-x "$optcsmdir/lsnode")
    {
        print STDERR
          "Cluster System Management (csm.server) lsnode command not installed\n";
        exit(-1);
    }

    # get the long hostname from CSM lsnode
    chop(@hostnames = `$optcsmdir/lsnode $::lsnodes_opt 2>/dev/null`);

    # user specified -a and lsnode failed then exit
    if ($? != 0)
    {
        print STDERR "Cluster System Management lsnodes command error\n";
        exit(-1);
    }

    foreach $hostname (@hostnames)
    {
        NodeUtils->add_nl($hostname);
    }
}

#--------------------------------------------------------------------------------

=head3    add_nl

    Add a host to the node list. Don't add a hostname if it is already there or
    if the is contained in another name which resolves to the same  host.

    Arguments:
        hostName
    Returns:
        none
    Globals:
        @main::nl;
    Error:
        Prints to STDERR.
    Example:
        none
    Comments:
        none

=cut

#-----------------------------------------------------------------------------

sub add_nl
{

    shift;    # get rid of the class
    my $host = shift;
    my ($hostname, @hostnames);
    my ($newname, $name, $aliases, $addtype, $length, @addrs);
    $host =~ s/\s//g;

    # Now loop through hosts and return if the host is found
    foreach $hostname (@::nl)
    {

        # before adding-  check to see if either hostnames are a shortname
        # for the same host
        if ($hostname =~ /^$host.*/ | $host =~ /^$hostname.*/)
        {

            # resolve hostname of new host to be added to list
            ($name, $aliases, $addtype, $length, @addrs) = gethostbyname($host);
            unless ($name)
            {
                print STDERR "Could not resolve hostname $host\n";
                return (1);
            }
            $newname = $name;

            # resolve hostname of existing node list host
            ($name, $aliases, $addtype, $length, @addrs) =
              gethostbyname($hostname);
            unless ($name)
            {
                print STDERR "Could not resolve hostname $host\n";
                return (1);
            }

            # If both names resolve to the same hostname, then do not add the host
            if ($name eq $newname)
            {
                return;
            }
        }
    }

    # Did not already have this host - add it to node list @::nl
    push(@::nl, $host);
}

#--------------------------------------------------------------------------------

=head3    buildWhereInList

    Build a "where" list

    Arguments:
        reference to an array of nodeNames
        array of where attributes
    Returns:
        where list
    Globals:
        none
    Error:
        none
    Example:
         $where = NodeUtils->buildWhereInList($ar2, $whereattr);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub buildWhereInList
{
    my ($class, $arrayref, $attrname) = @_;
    if (!defined($attrname) || !length($attrname)) { $attrname = 'Hostname'; }

    #todo: handle long cmd line
    my @newarray;
    foreach my $string (@$arrayref){
	my @vals = split ',|\s', $string;
	push @newarray, @vals;
    }
    my $where = qq/"$attrname IN ('/ . join("','", @newarray) . q/')"/;

    #my $comma = '';
    #foreach my $a (@$arrayref)
    #  {
    #   my $hostname = NodeUtils->tryHost($a);
    #   $where .= "$comma'$hostname'";
    #   $comma = ',';
    #  }
    #$where .= ')';
    return $where;
}

#--------------------------------------------------------------------------------

=head3    check_duplicate_nodes

          Make sure the nodes in @::Nodes are not already defined as CSM Nodes.

        Arguments:
                none
        Returns:
                0 - no duplicate nodes
                2 - duplicate nodes found
        Globals:
                none
        Error:
                returns 2 on error
        Example:
                 my $retCode = NodeUtils->check_duplicate_nodes;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub check_duplicate_nodes
{
    my ($returncode) = 0;
    my ($n, $m, $p);
    my ($duplicate_ManagedNodes);

    for $n (0 .. $#::Nodes)
    {
        for $m (0 .. $#::ManagedNodes)
        {
            if ($::Nodes[$n]{"hostname"} eq $::ManagedNodes[$m]{"Hostname"})
            {
                $duplicate_ManagedNodes .=
                  $::ManagedNodes[$m]{"Hostname"} . " ";
            }
        }
    }

    if ($duplicate_ManagedNodes)
    {
        NodeUtils->message('E', 'EMsgALREADY_DEFINED_MANAGEDNODES',
                           $duplicate_ManagedNodes);
        $returncode = 2;
    }

    return ($returncode);
}

#--------------------------------------------------------------------------------

=head3    expandExclusionRange

    Expand exclusion ranges that start with a minus.

    Arguments:
        $nodeList
        $list of expended group nodes
    Returns:
        array of nodeNames
    Globals:
        none
    Error:
        none
    Example:
        _
        if ($node =~ /^-/) {
            push @nodes, NodeUtils->expandExclusionRange($node, $groupExpansion);
        }    
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandExclusionRange
{
    my ($class, $node, $groupExpansion) = @_;

    #my (@groups, @nodes);
    $node =~ s/^-//;    # get rid of the leading minus
    my @nodes = NodeUtils->expandRanges($groupExpansion, $node);

    # Prepend a minus on each name.  These names will be excluded later.
    foreach my $n (@nodes) { $n =~ s/^/-/; }
    return @nodes;
}

#--------------------------------------------------------------------------------

=head3    expandGroupRange

     Expand group ranges such as:  g or g1-g3 or 1-3 or g1+2

    Arguments:
        Expand range values over a group.
    Returns:
        array of expended goup ranges.
    Globals:
        none
    Error:
        none
    Example:
        if ($node =~ /^-/) {
            push @nodes, NodeUtils->expandGroupRange($node, $groupExpansion);
        }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandGroupRange
{
    my ($class, $group, $groupExpansion) = @_;
    my (@groups, @nodes);

    # First expand into multiple groups if it is a range
    $group =~ s/^\+//;
    @groups = NodeUtils->expandNodeRange($group);

    if ($groupExpansion)
    {

        # Now get memberlist for each group
        $NODEGROUPEXPMEM_WARNING = 0;
        my $outref = NodeUtils->listNodeGroupExpMem(@groups);
        $NODEGROUPEXPMEM_WARNING = 1;

        # If the name did not match a group, then assume it is a hostname
        if (scalar(@groups) == 1 && scalar(@$outref) == 0)
        {
            return "+$groups[0]";
        }
        foreach my $row (@$outref)
        {
            my ($name, $nodelist) = $row =~ /^(.+):\|:\{(.*)\}$/;

            #push @nodes, NodeUtils->expandRanges(split(/,/, $nodelist));
            push @nodes, split(/,/, $nodelist);
        }
        return @nodes;
    }
    else    # do not expand groups
    {

        # Put the plus sign back on the group names
        foreach my $g (@groups) { $g =~ s/^/\+/; }
        return @groups;
    }

}

#--------------------------------------------------------------------------------

=head3    expandNodeRange

    Expand node ranges such as :
        n1-n3 or
        1-3 or
        n1+2 or
        2 or
        n1.ibm.com-n3.ibm.com or
        n1.ibm.com+2.
    Arguments:
        node range string
    Returns:
        array of nodeNames representing the expansion
    Globals:
        none
    Error:
        none
    Example:
         @groups = NodeUtils->expandNodeRange($group);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandNodeRange
{
    my ($class, $node) = @_;
    my (@nodes, $fRoot, $fDomain, $fNum, $eRoot, $eNum, $eDomain);
    if ($node =~ /-/)    # a range
    {
        my ($front, $end) = split('-', $node, 2);

        # Get the roots of the front part of the range and the end.
        # If there is any problem in the form, assume it is not a range
        ($fRoot, $fNum, $fDomain) = $front =~ /^(.*?)(\d+)(\..+)?$/;
        ($eRoot, $eNum, $eDomain) = $end   =~ /^(.*?)(\d+)(\..+)?$/;

        #print "fRoot=$fRoot, fNum=$fNum, eRoot=$eRoot, eNum=$eNum\n";
        if (   !defined($fNum)
            || !defined($eNum)
            || $fNum >= $eNum
            || $eRoot   ne $fRoot
            || $eDomain ne $fDomain)
        {
            return $node;
        }
    }
    elsif ($node =~ /\+/)    # a base node name plus an increment
    {
        my ($front, $increment) = split(/\+/, $node, 2);
        ($fRoot, $fNum, $fDomain) = $front =~ /^(.*?)(\d+)(\..+)?$/;
        if (!defined($fNum) || !($increment =~ /^\d+$/)) { return $node; }
        if ($ENV{CSM_XCAT_COMPAT} == 1) { $eNum = $fNum + $increment - 1; }
        else { $eNum = $fNum + $increment; }
    }
    elsif ($node =~ /^\d+$/)    # an all numeric node name
    {
        return $ENV{CSM_NODE_PREFIX} . $node;
    }
    else { return $node; }      # no range syntax at all

    # Handle 5-8 and 5+8 cases
    if (!length($fRoot) && !length($fDomain))
    {
        $fRoot = $ENV{CSM_NODE_PREFIX};
        if (!defined($fRoot)) { return $node; }
    }

    my $prefix;
    foreach my $suffix ($fNum .. $eNum)
    {
        my $numOfZeros = (length($fNum) - length($suffix));
        my $prefix     = '0' x $numOfZeros;
        push @nodes, "$fRoot$prefix$suffix$fDomain";
    }

    return @nodes;
}

#-------------------------------------------------------------------------------

=head3    expandBracketRange

    Expand node ranges with bracket such as :
        n[001-005].ibm.com or
        node[a-z]-cluster
    Arguments:
        node range string
    Returns:
        array of nodeNames representing the expansion
    Globals:
        none
    Error:
        none
    Example:
         @groups = NodeUtils->expandBracketRange($group);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandBracketRange
{
    my ($class, $node) = @_;
    my @nodes;

    my ($front, $rest) = split('\[', $node, 2);
    my ($nodes, $end) = split('\]', $rest, 2);

    #print "front = $front, nodes = $nodes, end = $end\n";
    if (!defined($end)) { return $node; }    # if no "]" in the syntax

    my ($first, $last) = split('-', $nodes, 2);

    if (($first =~ /^(\d+\.?\d*|\.\d+)$/) && ($last =~ /^(\d+\.?\d*|\.\d+)$/))
    {
       if ($first >= $last ) { return $node; }
       my $prefix;
       foreach my $suffix ($first .. $last)
       {
           my $numOfZeros = (length($first) - length($suffix));
           my $prefix     = '0' x $numOfZeros;
           push @nodes, "$front$prefix$suffix$end";
       }
    }
    elsif (($first =~ /\D/) && ($last =~ /\D/))  #for nondigit noderange
    {
       #print "have nondigit noderange\n";
       my $firstnum = ord($first);
       my $lastnum = ord($last);
       foreach my $num ($firstnum .. $lastnum)
       {
          my $ch = chr($num);
          #print "the node is $front$ch$end\n";
          push @nodes, "$front$ch$end";
       }
    }
    else
    {
       return $node;
    }

    return @nodes;
}

#--------------------------------------------------------------------------------

=head3    expandRanges

    Expands node and group entries if they use any of the node range syntax.

    EXAMPLES:
      node01-node05:  node01, node02, node03, node04, node05
      n8-n11:  n8, n9, n10, n11
      frame2n5-frame2n7:  frame2n5, frame2n6, frame2n7
      15-20:  n15, n16, n17, n18, n19, n20 (assuming CSM_NODE_PREFIX is set to n)
      n8+3:  n8, n9, n10
      8+3:  n8, n9, n10
      8:  n8
      +g1:  n1, n2, n3 (assuming g1 was a group containing n1, n2, n3)
      -n2:  exclude n2
      -n2-n4:  exclude n2, n3, n4
      -+g1:  exclude the members of g1
      n[01-05]: n01, n02, n03, n04, n05
      node[a-c]-cluster: nodea-cluster, nodeb-cluster, nodec-cluster

     SOME ADDITIONAL RULES:
      - no spaces in the entry
      - the roots of the 1st and last node names must match
      - a name that starts with plus, but is not a valid group will be interpreted as a node name (including the plus)
      - If the right format is not found, it just returns the whole entry as a
        node name.  This means that most hostnames with dashes in them will still be
        treated as a regular hostname.
      - The bracket node range syntax (as the last two examples above ) can not
        be used together with any other noderange syntax.
      - The bracket node range syntax can only accept the digits or single
        character in the bracket.
      - Only bracket node range syntax support the hostname with dashes in it.

     DIFFERENCES FROM XCAT NODE RANGES:
      - do not support non-numeric ranges based on definition order of nodes
      - file input with -f
      - regular expressions via dynamic nodegroups
      - suffix not supported in node ranges
      - groups specified with + operator or with -N
      - ranges not supported with hostnames that have dashes in them
      - n1+2 means n1,n2,n3 unless CSM_XCAT_COMPAT is 1, then n1+2 means n1,n2

    ENVIRONEMENT VARIABLES:
      CSM_NO_NODERANGES - disable expansion of node ranges
      CSM_NODE_PREFIX - text to prepend to ranges like 1-5
      CSM_XCAT_COMPAT - if set to 1, then n1+2 means n1,n2

=cut

#--------------------------------------------------------------------------------

sub expandRanges
{
    shift;    # get rid of class name
    my $groupExpansion = shift;

    # The rest of @_ are the node names
    if (!defined($NO_NODERANGES))
    {
        $NO_NODERANGES = defined($ENV{CSM_NO_NODERANGES});
    }
    if ($NO_NODERANGES) { return @_; }

    my @nodes;
    foreach my $node (@_)
    {
        if ($node =~ /\[/)
        {
            #print "node range with bracket\n";
            push @nodes, NodeUtils->expandBracketRange($node);
        }
        elsif ($node =~ /^-/)
        {
            push @nodes,
              NodeUtils->expandExclusionRange($node, $groupExpansion);
        }
        elsif ($node =~ /^\+/)
        {
            push @nodes, NodeUtils->expandGroupRange($node, $groupExpansion);
        }
        elsif ($node =~ /-|\+/ || $node =~ /^\d+$/)
        {
            push @nodes, NodeUtils->expandNodeRange($node);
        }
        else { push @nodes, $node; }
    }

    return @nodes;
}

#--------------------------------------------------------------------------------

=head3    gatherNodeList

    Processes all the ways a user can specify nodes to our commands and creates an
    array with the whole list.  The list is checked for duplicates.  A reference to
    the array is returned.  This function will process -n, -N, and -f.  If nodes can
    be passed in as positional args, pass a reference to ARGV (\@ARGV) into this function.

    Arguments:
           arrayref -    reference to ARGV (\@ARGV).  NOTE: If you are going to pass an opthashref,
                you need to also pass an arrayref before it (the arrayref can reference
                an empty array - use []).

           opthashref -    a optional reference to a hash with the following keys:

                NodeFile -    1 or name of file containing node list.
                If 1, it will not look in a file at all.
                If undefined, this function will look in the file specified by $::opt_f.

                NodeGrp -    string containing node groups separated by commas or spaces.
                If undefined, it will look in $::opt_N.

    Returns:
        reference to an array of nodeNames.
    Globals:
        opt_ globals
    Error:
        $NodeUtils::errno = 30;
    Example:
         my $refnodes =
            NodeUtils->gatherNodeList(\@nodelist, \%opthashref);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub gatherNodeList
{
    my ($class, $arrayref, $opthashref) = @_;
    my $nodes = [];    # create a reference to an array
    if (defined($arrayref))
    {
        foreach my $e (@$arrayref)
        {
            push @$nodes, NodeUtils->expandRanges(1, split(/[, ]+/, $e));
        }
    }
    if (defined($::opt_n))
    {
        push @$nodes, NodeUtils->expandRanges(1, split(/[, ]+/, $::opt_n));
    }
    my $groups = $$opthashref{'NodeGrp'} ? $$opthashref{'NodeGrp'} : $::opt_N;
    if (defined($groups))    # they specified node groups
    {
        my $outref = NodeUtils->listNodeGroupExpMem(split(/[, ]+/, $groups));
        foreach my $row (@$outref)
        {
            my ($name, $nodelist) = $row =~ /^(.+):\|:\{(.*)\}$/;

            #            push @$nodes, NodeUtils->expandRanges(split(/,/, $nodelist));
            push @$nodes, split(/,/, $nodelist);
        }
    }
    if (!defined($$opthashref{'NodeFile'}) || $$opthashref{'NodeFile'} ne "1")
    {
        my $file =
          $$opthashref{'NodeFile'} ? $$opthashref{'NodeFile'} : $::opt_f;
        if (defined($file))    # read the node list from the file
        {
            if (open(NODELIST, $file))
            {
                while (<NODELIST>)
                {
                    chomp($_);
                    push @$nodes,
                      NodeUtils->expandRanges(1, split(/[, ]+/, $_));
                }
                close(NODELIST);
            }
            else
            {
                if (!$NodeUtils::NO_MESSAGES)
                {
                    NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
                                         'E', 'EMsgNODELIST_FILE', $file, "$!");
                }
                $NodeUtils::errno = 30;
            }
        }
    }
    return $nodes;
}

#--------------------------------------------------------------------------------

=head3    generate_node_range

          Generate the list of nodes to define.  If the starting IP address
          (or hostname) and the count are provided, generate all the IP addresses
          from the starting IP address up to the correct ending number.

        Arguments:
                none
        Returns:
               @Nodes  - an arrary of nodenames
        Globals:
                @::ClusterOptions
                @$::nodelist
        Error:
                E2 message if no nodes are available from @$::nodelist
        Example:
                 NodeUtils->generate_node_range;
        Comments:
                might be good to give more info on the globals

=cut

#--------------------------------------------------------------------------------

sub generate_node_range
{
    my (@Nodes);
    my $i = 0;
    my ($node, $hostname, $ipaddr, $shorthost);

    # Generate a range of IP addresses based on the starting_nodename
    # and the node_count
    if (    $::ClusterOptions{"starting_nodename"}
        and $::ClusterOptions{"node_count"})
    {

        # Set the first node to the starting nodename
        $node = $::ClusterOptions{"starting_nodename"};

        # Increment the IP Address up to the number in node_count
        while ($i < $::ClusterOptions{"node_count"})
        {

            # Get the IP Address and hostname for the node.
            # getHost can accept either an IP address or a hostname as its
            # input parameter.
            ($hostname, $ipaddr) = NodeUtils->getHost($node);
            ($shorthost = $hostname) =~ s/\..*$//;

            $Nodes[$i]{"name"}      = $shorthost;
            $Nodes[$i]{"shorthost"} = $shorthost;
            $Nodes[$i]{"hostname"}  = $hostname;
            $Nodes[$i]{"ipaddr"}    = $ipaddr;

            $node = InstallUtils->inc_ip($ipaddr);    # Get the next IP Address
            $i++;
        }
    }
    elsif (@$::nodelist)
    {
        $i = 0;
        foreach my $node (@$::nodelist)
        {
            ($hostname, $ipaddr) = NodeUtils->getHost($node);
            ($shorthost = $hostname) =~ s/\..*$//;

            $Nodes[$i]{"name"}      = $shorthost;
            $Nodes[$i]{"shorthost"} = $shorthost;
            $Nodes[$i]{"hostname"}  = $hostname;
            $Nodes[$i]{"ipaddr"}    = $ipaddr;

            $i++;
        }
    }
    else
    {

        #die "No nodes provided!\n";
        NodeUtils->message('E2', 'EMsgNoNodesProvided');
    }

    if ($::VERBOSE)
    {
        NodeUtils->message('V', 'IMsgNEW_NODES_TO_DEFINE');
        for $i (0 .. $#Nodes)
        {
            NodeUtils->message('I', 'IMsgShow_Output', $Nodes[$i]{"hostname"});
        }
    }

    return @Nodes;
}

#--------------------------------------------------------------------------------

=head3    get_target_nodes

        Get a list of target nodes from the command line 

        Arguments:
                (\@ARGV) either from @ARGV 
                $::opt_n ($node group string) 
                $::opt_N $file containing node list 1 -- skips the check for not
                        found nodes
        Returns:
                \@DestNode      = reference to list of all target nodes
                \@lsnode_info   = reference to a list of results from lsnode command
                                  (only for the nodes in @DestNode)
                \%DestNodeHash  = reference to a hash of hostnames and attributes
                                  (foreach node in @Destnode):
                                  $DestNodeHash{$hostname}{$attribute_name} = "attribute value"
                                  For the list of attributes see $lsnode_attr
        Globals:
                $::ALL          - Distribute to all nodes
                $::MANAGED      - Distribute to all nodes where Mode="Managed"
                $::PRE_MANAGED  - Distribute to all nodes where Mode="PreManaged"
        Error:
                None documented
        Example
                my ($ref_DestNode, $ref_lsnode_info, $ref_DestNodeHash) =
                        NodeUtils->get_target_nodes(\@ARGV, $::NODE_GRPS, $::FILE);
        Comments:
                Common method for getting node list from command line.

=cut

#--------------------------------------------------------------------------------

sub get_target_nodes
{
    my ($class, $ref_nodelist, $nodegrp_list, $file, $skipNFcheck) = @_;
    my @nodelist = @$ref_nodelist;
    my (
        @DestNode,   @DestGroup,   %DestKeyTemp,
        %all_groups, @lsnode_info, @empty_array
        );

    my @real_nodelist;    #split the nodes if there are commas
    foreach my $n (@nodelist)
    {
        if ($n =~ m/,/)
        {
            my @tmp = split ',', $n;
            foreach my $t (@tmp)
            {
                push @real_nodelist, $t;
            }
        }
        else
        {
            push @real_nodelist, $n;
        }
    }
    @nodelist = @real_nodelist;
    undef @real_nodelist;

    my $lsnode_attr =
      "Hostname,ManagementServer,InstallOSName,InstallCSMVersion,InstallDistributionVersion,InstallDistributionName,InstallPkgArchitecture,Mode,InstallAdapterMacaddr,InstallAdapterName,InstallAdapterType,InstallAdapterDuplex,InstallAdapterSpeed,InstallMethod,ConsoleSerialDevice,Status,InstallServer,InstallTemplate,PowerMethod,InstallDiskType,InstallDisk,PowerStatus,ConsoleSerialSpeed,InstallAdapterGateway";

    # These delimeters are used with the lsnode command.  A simple colon (:)
    # cannot be used since there are colons in InstallAdapterMacaddr.
    #my $delim = ':|:';        # Used on the lsnode command
    my $check_delim = ':\|:';    # Used when splitting the line apart

    if ($::ALL || $::MANAGED || $::PRE_MANAGED)
    {                            #distribute to all nodes of a certain set
        my $select_string;
        if ($::MANAGED)
        {
            $select_string = "Mode=\"Managed\"";
        }
        elsif ($::PRE_MANAGED)
        {
            $select_string = "Mode=\"PreManaged\"";
        }
        else
        {                        #just managednodes
            $select_string = "";
        }
        my %opthash = (WhereStr => $select_string);
        my $ref_lsnode_info =
          NodeUtils->listNodeAttrs(\@empty_array, $lsnode_attr, \%opthash);
        @lsnode_info = @$ref_lsnode_info;

        foreach my $line (@lsnode_info)
        {
            chomp $line;
            my $hostname = (split /$check_delim/, $line)[0];
            push @DestNode, $hostname;
        }
    }
    else
    {    #we are not distributing to all nodes of a certain mode
        my %opthashref = ();
        if ($file)
        {
            %opthashref = (NodeFile => $file, NodeGrp => $nodegrp_list);
        }
        else
        {
            %opthashref = (NodeFile => 1, NodeGrp => $nodegrp_list);
        }
        my $refnodes = NodeUtils->gatherNodeList(\@nodelist, \%opthashref);
        if (scalar @$refnodes)
        {
            my $ref_lsnode_info =
              NodeUtils->listNodeAttrs($refnodes, $lsnode_attr);
            @lsnode_info = @$ref_lsnode_info;
            if (!$skipNFcheck)
            {
                InstallUtils->checkForNotFound($refnodes);
            }

        }
        else
        {
            @lsnode_info = ();
        }
    }

    my %DestNodeHash;
    foreach my $line (@lsnode_info)
    {    #this only has node names in it from the cluster
        my @attributes = split /$check_delim/, $line;
        my $hostname = $attributes[0];
        chomp $line;
        my @attr_names = split ',', $lsnode_attr;
        my $index = 0;
        foreach my $attr (@attr_names)
        {
            $DestNodeHash{$hostname}{$attr} = $attributes[$index];            
            $index++;
            # should recognize both "none" and "NONE" for ConsoleSerialDevice 
            if (($attr eq "ConsoleSerialDevice") && (uc($DestNodeHash{$hostname}{$attr}) eq "NONE")) {
            	$DestNodeHash{$hostname}{$attr} = "NONE";	
            }
        }
    }

    if (@::VALID_INSTALLMETHODS)
    {
        my %meths;
        foreach my $method (@::VALID_INSTALLMETHODS)
        {
            $meths{$method} = 1;
        }
        my @methString = keys %meths;
        foreach my $target (keys %DestNodeHash)
        {
            if (!$meths{$DestNodeHash{$target}{'InstallMethod'}})
            {
                if (!($::ALL || $::MANAGED || $::PRE_MANAGED))
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                        'csminstall', 'E1', 'EMsgINVALID_INSTALL_METH', $target,
                        "@methString");
                }
                else
                {
                    NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                         'csminstall', 'W', 'EMsgINVALID_INSTALL_METH', $target,
                         "@methString");
                    delete $DestNodeHash{$target};
                }
            }
        }
    }

    my @tmpDestNode = keys %DestNodeHash;
    my @return_array = (\@tmpDestNode, \@lsnode_info, \%DestNodeHash);
    return @return_array;
}

#--------------------------------------------------------------------------------

=head3    listNodeGroupExpMem

    Return the expanded member list for each of the node group names passed in.

    Arguments:
        One or more node groups as parameters
    Returns:
        reference to an array:

        Each element of the array represents one (1) row and has the format:

                    nodegroupname:|:{node1,node2,node3}


    Globals:
        none
    Error:
        none
    Example:
         my $outref =
            NodeUtils->listNodeGroupExpMem(@groups);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub listNodeGroupExpMem
{
    shift;    # get rid of the class arg - the rest of @_ are the group names
    my $where = '';
    if (scalar(@_))
    {

        # We do it this way instead of putting all the groups in one IN expression because
        # this way guarantees they will come back in the same order specified.
        foreach my $g (@_)
        {
            $where .= qq( -s IBM.NodeGroup::"Name='$g'"::Name::ExpMemberList);
        }
    }
    else { $where = '-s IBM.NodeGroup::::Name::ExpMemberList'; }

    # Get the data
    my $outref = NodeUtils->runrmccmd('lsrsrc-api', "-i -D ':|:'", $where);
    if ($::RUNCMD_RC)
    {
        $outref = [];
    }
    if (scalar(@_) && scalar(@$outref) < scalar(@_) && $NODEGROUPEXPMEM_WARNING)
    {
        if (scalar(@_) == 1)
        {
            if (!$NodeUtils::NO_MESSAGES)
            {
                NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'W',
                                          'EMsgGROUP_NOT_FOUND', $_[0]);
            }
            $NodeUtils::errno = 31;
        }
        else
        {
            if (!$NodeUtils::NO_MESSAGES)
            {
                NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'W',
                                    'EMsgSOME_GROUPS_NOT_FOUND', join(',', @_));
            }
            $NodeUtils::errno = 32;
        }
    }
    return $outref;
}

#--------------------------------------------------------------------------------

=head3    resolveAndUndup

    Take the reference to an array of node names and resolve each name to its
    primary hostname and then eliminate duplicates in the list.  Returns a reference
    to a new array.  This function is separate from gatherNodeList because it is
    rather expensive to do all the name resolutions, so this should only be called
    when necessary.  For example, if you are going to pass the node list to lsnode,
    lsnode will do this for you, so you do not need to call this.

    Arguments:
        reference to an array of nodeNames.
    Returns:
        Returns a reference to processed array. This function can also return a
        reference to a hash mapping each resolved name back to its original name.    
    Globals:
        none
    Error:
        none
    Example:
        _
    Comments:
        This function also processes exclusions (node names that start with minus),
        unless the CSM_NO_NODERANGES env var is set.

=cut

#--------------------------------------------------------------------------------

sub resolveAndUndup
{
    my ($class, $arrayref) = @_;
    if (!$NodeUtils::NO_MESSAGES)
    {
        NodeUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V',
                                  'IMsgRESOLVING');
    }
    my $hash    = {};
    my $exclude = {};

    #my @ar1;
    my $ar2 = [];
    if (!defined($NO_NODERANGES))
    {
        $NO_NODERANGES = defined($ENV{CSM_NO_NODERANGES});
    }

    # Go through the list once to find all the exlusions
    if (!$NO_NODERANGES)
    {
        foreach my $node (@$arrayref)
        {
            if ($node =~ /^-/)
            {
                my $n2 = substr($node, 1);
                my $hostname = NodeUtils->tryHost($n2);
                $$exclude{$hostname}++;
            }
        }
    }

    my $numnodes = scalar @$arrayref;
    if ($numnodes > 15)
    {    #if there are more than 15 nodes
        NodeUtils->cacheEtcHosts();    #cache /etc/hosts if used
    }

    # Now go through the list a 2nd time
    foreach my $node (@$arrayref)
    {
        if (!$NO_NODERANGES && $node =~ /^-/)
        {
            next;
        }    # we already put the exclusions in the exclude hash
        my $resolved;
        my $hostname = NodeUtils->tryHost($node, \$resolved);
        if (!defined($$exclude{$hostname}))
        {
            if (!$resolved)

              # Hosts that are not resolved successfully
              # are placed under an empty key
            {
                $hostname = "";
                push @$ar2, $node;
            }

            if (!defined($$hash{$hostname}))
            {
                $$hash{$hostname} = [$node];
                if ($resolved)
                {
                    push @$ar2, $hostname;
                }
            }
            else
            {
                push(@{$$hash{$hostname}}, $node);    # record duplicates
            }
        }
    }

    if (wantarray) { return ($ar2, $hash, $exclude); }
    else { return $ar2; }
}

#--------------------------------------------------------------------------------

=head3    subtractOrIntersect

     Does @$g1-@$g2 and returns the resulting array. The arrays passed in
    and the array returned are all references.  If $intersect is 1, then
    it finds the intersection of @$g1 and @$g2 instead. g1 and g2 are 
    groups of nodeNames.

    Arguments:
        $ref_group1 
        $ref_group2 
        $bool_intersect.
    Returns:
        ref_array - result of subtraction or intersection.
    Globals:
        none
    Error:
        none
    Example:
        not used
    Comments:
        not used ??

=cut

#--------------------------------------------------------------------------------

sub subtractOrIntersect
{
    my ($class, $g1, $g2, $intersect) = @_;
    if ($intersect) { $intersect = 1; }    # we need it exactly 0 or 1
    else { $intersect = 0; }

    # make a hash out of g2
    my %g2hash;
    @g2hash{@$g2} = (1) x scalar(@$g2);

    #foreach (@$g2) { $g2hash{$_}++; }

    # go through @g1 and only copy elements to the returned array that are not in
    # %g2hash
    my $out = [];

    # this cryptic line says: if the element of g1 is not in g2 and we are
    # doing a subtraction, then add it to the out arrary.  Or if the element
    # of g1 is in g2 and we are doing the intersection, then add it to out.
    foreach my $g (@$g1)
    {
        if (defined($g2hash{$g}) == $intersect) { push @$out, $g; }
    }
    return $out;
}

#--------------------------------------------------------------------------------

=head2    Networking - Moved to NetworkUtils

=cut

#--------------------------------------------------------------------------------

=head3  cacheEtcHosts
    

    NetworkUtils->cacheEtcHosts

=cut

sub cacheEtcHosts { shift; return NetworkUtils->cacheEtcHosts(@_); }

#--------------------------------------------------------------------------------

=head3  getHost
    

    NetworkUtils->getHost

=cut

sub getHost { shift; return NetworkUtils->getHost(@_); }

#--------------------------------------------------------------------------------

=head3  getRSCThostname
    

    NetworkUtils->getRSCThostname

=cut

sub getRSCThostname { shift; return NetworkUtils->getRSCThostname(@_); }

#--------------------------------------------------------------------------------

=head3  isIpaddr
    

    NetworkUtils->isIpaddr

=cut

sub isIpaddr { shift; return NetworkUtils->isIpaddr(@_); }

#--------------------------------------------------------------------------------

=head3  service
    

    NetworkUtils->service

=cut

sub service { shift; return NetworkUtils->service(@_); }

#--------------------------------------------------------------------------------

=head3  tryHost
    

    NetworkUtils->tryHost

=cut

sub tryHost { shift; return NetworkUtils->tryHost(@_); }

#--------------------------------------------------------------------------------

1;

